/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.handcar;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.handcar.HandcarBlock;
import com.railwayteam.railways.mixin_interfaces.IDeployAnywayBlockItem;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.packet.CurvedTrackHandcarPlacementPacket;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainPacket;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandcarItem
extends class_1747
implements IDeployAnywayBlockItem {
    public HandcarItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    private HandcarBlock getBogeyBlock() {
        return (HandcarBlock)this.method_7711();
    }

    @NotNull
    public class_1269 method_7884(@NotNull class_1838 context) {
        class_1799 stack = context.method_8041();
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2680 state = level.method_8320(pos);
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)class_22482;
            TrackMaterial.TrackType trackType = track.getMaterial().trackType;
            if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
                return class_1269.field_5814;
            }
            if (level.field_9236) {
                return class_1269.field_5812;
            }
            class_243 lookAngle = player.method_5720();
            boolean front = track.getNearestTrackAxis((class_1922)level, pos, state, lookAngle).getSecond() == class_2350.class_2352.field_11056;
            MutableObject result = new MutableObject(null);
            MutableObject resultLoc = new MutableObject(null);
            HandcarItem.withGraphLocation(level, pos, front, null, (overlap, location) -> {
                result.setValue(overlap);
                resultLoc.setValue(location);
            });
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.method_7353((class_2561)CreateLang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.play(level, null, (class_2382)pos, 0.5f, 1.0f);
                return class_1269.field_5814;
            }
            TrackGraphLocation loc = (TrackGraphLocation)resultLoc.getValue();
            if (loc == null) {
                return class_1269.field_5814;
            }
            boolean success = this.placeHandcar(loc, level, player, pos);
            if (success) {
                stack.method_7934(1);
            }
            return success ? class_1269.field_5812 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @ApiStatus.Internal
    @NotNull
    public boolean placeHandcar(TrackGraphLocation trackGraphLocation, class_1937 level, class_1657 player, class_2338 soundPos) {
        TrackGraph graph = trackGraphLocation.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)trackGraphLocation.edge.getFirst());
        TrackNode node2 = graph.locateNode((TrackNodeLocation)trackGraphLocation.edge.getSecond());
        TrackEdge edge = (TrackEdge)graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return false;
        }
        double offset = this.getBogeyBlock().getWheelPointSpacing() / 2.0;
        TravellingPoint tp1 = new TravellingPoint(node1, node2, edge, trackGraphLocation.position, false);
        TravellingPoint tp2 = new TravellingPoint(node1, node2, edge, trackGraphLocation.position, false);
        tp1.travel(graph, offset, tp1.steer(TravellingPoint.SteerDirection.NONE, new class_243(0.0, 1.0, 0.0)));
        tp2.travel(graph, -offset, tp2.steer(TravellingPoint.SteerDirection.NONE, new class_243(0.0, 1.0, 0.0)));
        if (!(level instanceof class_3218)) {
            return false;
        }
        class_3218 serverLevel = (class_3218)level;
        this.makeTrain(player.method_5667(), graph, tp1, tp2, serverLevel);
        AllSoundEvents.CONTROLLER_CLICK.play(level, null, (class_2382)soundPos, 1.0f, 1.0f);
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        TrackBlockEntity be = selection.blockEntity();
        BezierTrackPointLocation loc = selection.loc();
        boolean front = player.method_5720().method_1026(selection.direction()) < 0.0;
        BezierConnection bc = (BezierConnection)be.getConnections().get(loc.curveTarget());
        TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
        if (trackType != TrackMaterial.TrackType.STANDARD && trackType != CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return false;
        }
        CRPackets.PACKETS.send(new CurvedTrackHandcarPlacementPacket(be.method_11016(), loc.curveTarget(), loc.segment(), front, player.method_31548().field_7545));
        return true;
    }

    @Nullable
    private Train makeTrain(UUID owner, TrackGraph graph, TravellingPoint tp1, TravellingPoint tp2, class_3218 level) {
        CarriageContraption contraption = new CarriageContraption(class_2350.field_11034);
        SchematicLevel assemblyWorld = new SchematicLevel((class_1937)level);
        class_3499 template = level.method_14183().method_15094(Railways.asResource("handcar/assembly")).orElse(null);
        if (template == null) {
            return null;
        }
        class_3492 settings = new class_3492();
        template.method_15172((class_5425)assemblyWorld, class_2338.field_10980, class_2338.field_10980, settings, level.method_8409(), 2);
        assemblyWorld.getEntityList().forEach(e -> {
            e.field_6002 = assemblyWorld;
        });
        try {
            contraption.assemble((class_1937)assemblyWorld, new class_2338(1, 1, 1));
        }
        catch (AssemblyException e2) {
            return null;
        }
        contraption.expandBoundsAroundAxis(class_2350.class_2351.field_11052);
        CarriageBogey bogey = new CarriageBogey((AbstractBogeyBlock)this.getBogeyBlock(), false, null, tp1, tp2);
        Carriage carriage = new Carriage(bogey, null, 0);
        Train train = new Train(UUID.randomUUID(), owner, graph, List.of(carriage), new ArrayList(), true);
        ((IHandcarTrain)train).railways$setHandcar(true);
        carriage.setContraption((class_1937)level, contraption);
        train.name = class_2561.method_43471((String)"block.railways.handcar");
        train.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.addTrain(train);
        CRPackets.PACKETS.sendTo(PlayerSelection.all(), (SimplePacketBase)new TrainPacket(train, true));
        return train;
    }

    public static void withGraphLocation(class_1937 level, class_2338 pos, boolean front, BezierTrackPointLocation targetBezier, BiConsumer<TrackTargetingBlockItem.OverlapResult, TrackGraphLocation> callback) {
        TrackGraphLocation location;
        class_2680 state = level.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.NO_TRACK, null);
            return;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        List trackAxes = track.getTrackAxes((class_1922)level, pos, state);
        if (targetBezier == null && trackAxes.size() > 1) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.JUNCTION, null);
            return;
        }
        class_2350.class_2352 targetDirection = front ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        TrackGraphLocation trackGraphLocation = location = targetBezier != null ? TrackGraphHelper.getBezierGraphLocationAt((class_1937)level, (class_2338)pos, (class_2350.class_2352)targetDirection, (BezierTrackPointLocation)targetBezier) : TrackGraphHelper.getGraphLocationAt((class_1937)level, (class_2338)pos, (class_2350.class_2352)targetDirection, (class_243)((class_243)trackAxes.get(0)));
        if (location == null) {
            callback.accept(TrackTargetingBlockItem.OverlapResult.NO_TRACK, null);
            return;
        }
        Couple nodes = location.edge.map(arg_0 -> ((TrackGraph)location.graph).locateNode(arg_0));
        TrackEdge edge = location.graph.getConnection(nodes);
        if (edge == null) {
            return;
        }
        callback.accept(TrackTargetingBlockItem.OverlapResult.VALID, location);
    }
}

